@extends('theme::layouts.public')
@section('content')
    <div class="container wrapper">
        <div id="content">
            <form action="{{ $page_details['route'] }}" method="POST" class="withBackground formInline">
                {{ csrf_field() }}
                {{ method_field($page_details['method']) }}
                <fieldset>
                    <div class="row {{ $errors->has('addresses.name') ? 'errorWrap showError' : '' }}">
                        <label for="name">{{ trans('core::fields.address.name') }}</label>
                        <div class="inputWrap">
                            <input name="addresses[name]" id="name"
                                   value="{{ old('addresses.name', $address->name) }}">
                            @include('core::public.addresses.error', ['field' => 'addresses.name'])
                        </div>
                    </div>
                    <div class="row {{ $errors->has('addresses.first_name') ? 'errorWrap showError' : '' }}">
                        <label for="first_name">{{ trans('core::fields.address.first_name') }}</label>
                        <div class="inputWrap">
                            <input name="addresses[first_name]" id="first_name"
                                   value="{{ old('addresses.first_name', $address->first_name) }}">
                            @include('core::public.addresses.error', ['field' => 'addresses.first_name'])
                        </div>
                    </div>
                    <div class="row {{ $errors->has('addresses.last_name') ? 'errorWrap showError' : '' }}">
                        <label for="last_name">{{ trans('core::fields.address.last_name') }}</label>
                        <div class="inputWrap">
                            <input name="addresses[last_name]" id="last_name"
                                   value="{{ old('addresses.last_name', $address->last_name) }}">
                            @include('core::public.addresses.error', ['field' => 'addresses.last_name'])
                        </div>
                    </div>

                    <address-finder action="{{ route('findAddress') }}"
                                    inline-form="1"
                                    country-action="{{ route('listCountries') }}"
                                    enabled="{{ config('core.address_finder.enabled') }}"
                                    errors-in="{{ $errors->toJSON() }}"
                                    values="{{ json_encode([
                                        'address1' => old('addresses.address1', $address->address1),
                                        'address2' => old('addresses.address2', $address->address2),
                                        'city' => old('addresses.city', $address->city),
                                        'postcode' => old('addresses.postcode', $address->postcode),
                                        'state' => old('addresses.state', $address->state),
                                        'country' => old('addresses.country', $address->country),
                                    ]) }}"
                    ></address-finder>
                </fieldset>
                <button type="submit" class="button">{{ trans('core::text.save') }}</button>
            </form>
        </div>
    </div>
@endsection
