<?php
/**
 * Class CurrencyController
 *
 * @package Mtc\Core
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */

namespace Mtc\Core\Http\Controllers;

use Mtc\Core\Http\Requests;
use Illuminate\Http\Request;
use Mtc\Core\Models\Currency;

/**
 * Class CurrencyController
 *
 * Public controller for switching between currencies
 *
 * @package Mtc\Core
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 * @version 2017-05-30
 */
class CurrencyController extends Controller
{
    /**
     * Process request for changing the currency on site.
     *
     * @param Request $request Incoming Request
     * @param Currency $currency Currency Model
     *
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $rate_code = $request->input('rate');

        // If no rate provided or currency switcher is not enabled go back before changing
        if (!$rate_code || !config('core.currencies_enabled')) {
            return redirect()->back();
        }

        // Fin currency object for given code
        $currency = Currency::getCachedCurrencyByCode($rate_code);

        // Only proceed if Currency was found
        if (!$currency) {
            return redirect()->back();
        }

        // change the currency in session and go back to previous page
        $request->session()->put(['currency_selected' =>  $currency->code]);
        return redirect()->back();
    }

}
