<?php
/**
 * Class CurrencyComposer
 *
 * @package Mtc\Core
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
namespace Mtc\Core\Http\ViewComposers;

use Illuminate\View\View;
use Mtc\Core\Models\Currency;

/**
 * Class CurrencyComposer
 *
 * Add in the Currency information for views
 *
 * @package Mtc\Core
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 * @version 2017-05-30
 */
class CurrencyComposer
{
    /**
     * Handle the view processing to add in required Currency data
     *
     * @param View $view
     */
    public function compose(View $view)
    {
        // Next steps are not relevant if currencies are disabled
        if (!config('core.currencies_enabled')) {
            return;
        }

        // Fetch all active currencies
        $currencies = Currency::where('active', 1)
            ->get();

        // Set the stored currency as selected one
        $selected_currency = $currencies
            ->where('code', session('currency_selected'))
            ->first();

        // Take the current currency out of the currency list
        $other_currencies = $currencies->reject(function ($currency) {
            return $currency->code === session('currency_selected');
        });

        // Add currencies to the view
        $view->with([
            'selected_currency' => $selected_currency,
            'currencies' => $other_currencies,
        ]);
    }

}
