<?php
/**
 * CustomUrl Class
 *
 * @package Mtc\Core
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
namespace Mtc\Core\Models\Seo;

use Illuminate\Database\Eloquent\Model;
use Mtc\Core\Nodeable;

/**
 * CustomUrl class
 *
 * This class stores the custom url instances and their binding to node.
 * The model itself has one relevant attribute - public_controller which points to the
 * controller that will have handleCustomUrlRequest method
 *
 * @package Mtc\Core
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
class CustomUrl extends Model
{
    use Nodeable;

    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'seo_custom_url';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'public_controller'
    ];

}
