<?php

namespace Mtc\Core\Providers;

use Illuminate\Support\Facades\Validator;
use Illuminate\Support\ServiceProvider;
use Mtc\Core\Country;
use Schema;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        Schema::defaultStringLength(191);

        // add validation rule named 'alpha_dash_slash'
        Validator::extend('alpha_dash_url', function ($attribute, $value, $parameters, $validator) {
            //allow all alpha-numeric characters with slashes and dashes
            return preg_match("#^/[a-zA-Z0-9_/-]+$#", $value);
        });

        Validator::replacer('alpha_dash_url', function ($message, $attribute, $rule, $parameters) {
            return "The $attribute field must contain alpha-numeric values with slashes and dashes. "
                . "It must start with /";
        });

        // add validation rule named 'alpha_dash_slash'
        Validator::extend('alpha_dash_file', function ($attribute, $value, $parameters, $validator) {
            //allow all alpha-numeric characters with slashes and dashes
            return preg_match("#^[a-zA-Z0-9_-]+\.[a-zA-Z]{3,4}$#", $value);
        });

        Validator::replacer('alpha_dash_file', function ($message, $attribute, $rule, $parameters) {
            return "File must be a filename that consists of alpha-numeric values"
                . " with slashes and/or dashes.";
        });

        // add validation rule named 'postcode'
        Validator::extendImplicit('postcode', function ($attribute, $value, $parameters, $validator) {
            // get country regex string & postcode status from database
            $country = Country::where('code', $parameters[0])->get(['has_postcodes', 'postcode_regex'])->first();
            if($country->has_postcodes) {
                return preg_match("#" . $country->postcode_regex . "#", $value);
            }
            return true;
        });

        Validator::replacer('postcode', function ($message, $attribute, $rule, $parameters) {
            return "Invalid Postcode";
        });
    }

    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        //
    }
}
