<?php

use Mtc\Core\Auth\Permission;
use Mtc\Core\Auth\Role;
use Illuminate\Database\Seeder;

class UserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $role = Role::firstOrNew(['id' => 1]);
        $role->id = 1;
        $role->name = 'mtc';
        $role->save();

        $permissions = [
            'management' => [
                'admin',
                'manage-users',
                'delete-users',
                'manage-roles',
                'manage-custom-fields',
                'manage-custom-field-groups',
                'manage-custom-field-taxonomies',
                'manage-currencies',
                'manage-emails',
                'admin-email-templates',
            ],
            'seo' => [
                'manage-seo',
                'manage-seo-defaults',
                'manage-urls',
                'manage-seo-pages',
                'manage-media-meta'
            ]
        ];

        collect($permissions)
            ->each(function ($group, $group_name) use ($role) {
                // Each group consists of permissions to seed
                collect($group)->each(function ($name) use ($role, $group_name) {
                    // Find or add the permission
                    $permission = Permission::firstOrNew(['name' => $name]);
                    $permission->permission_group = $group_name;
                    $permission->save();
                    if (!$role->hasPermissionTo($name)) {
                        $role->givePermissionTo($name);
                    }
                    return $permission;
                });
            });

        $role = Role::firstOrNew(['id' => 2]);
        $role->id = 2;
        $role->name = 'admin';
        $role->save();

        if (!$role->hasPermissionTo('admin')) {
            $role->givePermissionTo('admin');
        }
    }
}
