
Vue.filter('currency', function (value, base_currency) {
    let format = document.getElementById('selectedCurrency');

    // If we are loading the price in base currency we need to utilize the base format, otherwise the current format
    if (base_currency === 1) {
        format = format.getAttribute('data-base-format');
    } else {
        format = format.getAttribute('data-format');
        // we need to multiply the price by currently selected product rate
        value = document.getElementById('selectedCurrency').getAttribute('data-rate') * value;
    }
    /*
     * Load the currency #selectedCurrency element that holds the placeholder format for this currency
     * The placeholder will be set up to have 11.22 for cost so we need to change the costs accordingly
     * 11 must be replaced with full numbers of pounds/euros/dollars etc. (hence the bitwise division ~~(x/y))
     * 22 must be the pennies/cents with only 2 numbers, so clean it up too
     */
    return format
        .replace('11', ~~(value / 100))
        .replace('22', (Math.abs(value) % 100).toFixed(0));
});

Vue.filter('percentage', function (value) {
    return parseFloat(value).toFixed(2) + '%';
});
