<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="robots" content="noindex,nofollow">

    <title>@yield('title', 'Dashboard')</title>

    <!-- Bootstrap core CSS -->
    <link href="{{ mix('/css/admin.css') }}" rel="stylesheet">

    <!-- HTML5 shim and Respond.js for IE8 support of HTML5 elements and media queries -->
    <!--[if lt IE 9]>
        <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
        <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
    <![endif]-->
    @yield('header', '')
</head>

<body id="top">

    <div id="app">

        <nav class="navbar navbar-inverse navbar-fixed-top">
            <div class="container-fluid">
                <div class="navbar-header">
                    <button type="button" class="navbar-toggle collapsed" data-toggle="collapse" data-target="#navbar" aria-expanded="false" aria-controls="navbar">
                        <span class="sr-only">Toggle navigation</span>
                        <span class="icon-bar"></span>
                        <span class="icon-bar"></span>
                        <span class="icon-bar"></span>
                    </button>
                    <a class="navbar-brand" href="/admin/">
                        <img src="http://frs.mtcmedia.co.uk/images/logo.svg" alt="">
                        <strong>{{ config('app.name') }}</strong>
                        Admin Dashboard
                    </a>
                </div>
                <div id="navbar" class="navbar-collapse collapse">
                    <ul class="nav navbar-nav navbar-right">

                        @foreach (event('admin.navigation_bar') as $event)
                            {!! $event !!}
                        @endforeach
                        <li class="dropdown">
                            <a href="#" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-expanded="false">
                                {{ Auth::user()->name }} <span class="caret"></span>
                            </a>

                            <ul class="dropdown-menu" role="menu">
                                <li>
                                    <a href="{{ url('/logout') }}"
                                        onclick="event.preventDefault();
                                                 document.getElementById('logout-form').submit();">
                                        Logout
                                    </a>

                                    <form id="logout-form" action="{{ url('/logout') }}" method="POST" style="display: none;">
                                        {{ csrf_field() }}
                                    </form>
                                </li>
                            </ul>
                        </li>
                    </ul>
                    <form class="navbar-form navbar-right">
                        <search action="{{ route('core.admin.search') }}"></search>
                    </form>
                </div>
            </div>
        </nav>

        <div class="container-fluid">
            <div class="row">
                {!! \Mtc\Core\Admin\Menu::render() !!}

                <main class="col-sm-9 col-sm-offset-3 col-md-10 col-md-offset-2 main">
                    @include('core::layouts.partials.admin.header')
                    @yield('content')
                </main>
            </div>
        </div>

    </div>

    <!-- Global Core Object -->
    <script>
        window.Laravel = { csrfToken: '{{ csrf_token() }}' };
        window.enabled_languages = {!! $enabled_languages !!};
    </script>
    @includeIf('core::public.currency.switcher')
    <script type="text/javascript" src="{{ route('language_json') }}?{{ config('core.') }}"></script>
    @routes
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.1.0/jquery.min.js"></script>
    <script src="//cdn.tinymce.com/4/tinymce.min.js"></script>
    <script src="{{ mix('/js/admin.js') }}"></script>
    @yield('scripts', '')

</body>
</html>
