<?php
/**
 * RegisterCustomGroupModels Event
 *
 * PHP Version 7
 *
 * @category Mtc\Core\Events\Admin
 * @package  Mtc\Core
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */

namespace Mtc\Core\Events\Admin;

use Mtc\Core\CustomFields\CustomGroup;

/**
 * RegisterCustomGroupModels Event
 *
 * Triggered by CustomGroup::getRegisteredModels(), this lets any model be
 * defined as being available for use with CustomFields.
 *
 * @category Mtc\Core\Events\Admin
 * @package  Mtc\Core
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */
class RegisterCustomGroupModels
{
    /**
     * The group which has initiated the event.
     *
     * @var null|CustomGroup
     */
    public $group = null;

    /**
     * Build the event with information on the group.
     *
     * @param CustomGroup $group The group which has initiated the event.
     *
     * @return void
     */
    public function __construct(CustomGroup $group)
    {
        $this->group = $group;
    }
}
