<?php

namespace Mtc\Core\Http\Controllers;

use Auth;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Http\Request;
use Mtc\Core\Http\Resources\NodeResource;
use Mtc\Core\Node;

/**
 * Endpoint for listing nodes
 *
 * @category Mtc\Core
 * @package  Mtc\Core
 * @author   Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
class NodeController extends Controller
{
    /**
     * List the entries of a specific node type
     *
     * @param Request $request
     * @return \Illuminate\Http\Resources\Json\AnonymousResourceCollection
     */
    public function list(Request $request)
    {
        return NodeResource::collection(Node::query()
            ->where('status', 'published')
            ->where('nodeable_type', $request->input('node_type'))
            ->get());
    }
    /**
     * List the entries of a specific node type
     *
     * @param Request $request
     * @return Model
     */
    public function show(Request $request, Node $node)
    {
        return $node;
    }

}
