<?php
/**
 * StoreCustomGroup Request
 *
 * PHP Version 7
 *
 * @category Mtc\Core\Http\Requests\Admin
 * @package  Mtc\Core\Admin
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */

namespace Mtc\Core\Http\Requests\Admin;

use Illuminate\Foundation\Http\FormRequest;

/**
 * Validate an incoming request for storing custom group with custom rules.
 *
 * @category Mtc\Core\Http\Requests\Admin
 * @package  Mtc\Core\Admin
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */
class StoreCustomGroup extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'item.title' => 'required|max:255',
            'fields' => 'required|array',
            'fields.title' => 'array',
            'fields.column_name' => 'array',
            'fields.type' => 'array',
            'fields.list_id' => 'array',
        ];
    }
}
