<?php
/**
 * StoreSeoPageMetaValue Request
 *
 * PHP Version 7
 *
 * @category Mtc\Core\Http\Requests\Admin
 * @package  Mtc\Core\Admin
 * @author   Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */

namespace Mtc\Core\Http\Requests\Admin;

use Illuminate\Foundation\Http\FormRequest;

/**
 * Validate an incoming request for storing page meta information (title, description, h1) based on url
 *
 * @category Mtc\Core\Http\Requests\Admin
 * @package  Mtc\Core\Admin
 * @author   Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
class StoreSeoPageMetaValue extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {

        return [
            'url' => 'required|max:255',
            'title' => 'required|max:255',
            'description' => 'required|max:255',
        ];
    }
}
