<?php
/**
 * Class BespokeUrlMatcher
 *
 * @package Mtc\Core
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
namespace Mtc\Core\Listeners;

use Illuminate\Http\Response;
use Illuminate\Support\Facades\DB;
use Illuminate\View\View;
use Mtc\Core\Events\HttpNotFoundEvent;
use Mtc\Core\Models\Seo\CustomUrl;
use Mtc\Core\Node;

/**
 * Class BespokeUrlMatcher
 *
 * Event listener that matches given request against custom urls set for nodes
 *
 * @package Mtc\Core
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
class BespokeUrlMatcher
{
    /**
     * Handle the event.
     * Return supported menu types as a structured array.
     *
     * @param  HttpNotFoundEvent $event
     * @return Response|View Response or view depending on given controller
     */
    public function handle(HttpNotFoundEvent $event)
    {
        // Find if there is a node for this url
        $node = Node::whereRaw(DB::raw('\'' . $event->request->getPathInfo() . '\' LIKE CONCAT(`url`, "%")'))
            ->firstOrFail();

        // If this node is linked to an instance that has a public facing controller
        if (!empty($node->nodeable::$public_controller)) {

            // Get the controller name & action from the node linked entity
            list($controller_name, $controller_action) = explode('@', $node->nodeable::$public_controller);

            // if controller name and action was set up properly
            if ($controller_name && $controller_action) {

                // load controller and call the action
                $controller = new $controller_name;
                return $controller->{$controller_action}($event->request, $node->nodeable_id);
            }
        } elseif ($node->nodeable instanceof CustomUrl) {
            // Lets check if this controller exists before constructing it
            if (class_exists($node->nodeable->public_controller)) {
                $controller = new $node->nodeable->public_controller;

                // Lets check if this method exists before executing it
                if (method_exists($controller, 'handleCustomUrlRequest')) {
                    return $controller->handleCustomUrlRequest($event->request, $node);
                }
            }
        }
    }

}