<?php

namespace Mtc\Core\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

/**
 * Class TemplateEmail
 *
 * @package Mtc\ContactForm\Mail
 */
class TemplateEmail extends Mailable
{
    use Queueable, SerializesModels;

    /**
     * @var mixed $data Information to inject into email template
     */
    protected $data = [];

    /**
     * @var string $layout Layout used for email template
     */
    protected $layout = '';

    /**
     * @var string $subject Email Subject
     */
    public $subject = '';

    /**
     * TemplateEmail constructor.
     *
     * @param string $subject
     * @param string $layout
     * @param mixed $data
     */
    public function __construct($subject, $layout, $data)
    {
        $this->subject = $subject;
        $this->layout = $layout;
        $this->data = array_merge($data, config('mail.email_templates'));
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->markdown($this->layout ?: 'core::emails.notification')
            ->subject($this->subject)
            ->with($this->data);
    }
}