<?php
/**
 * Class AddDefaultAddressToUsersTable
 *
 * @author James Neill <james.neill@mtcmedia.co.uk>
 */

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

/**
 * Class AddDefaultAddressToUsersTable
 *
 * @author James Neill <james.neill@mtcmedia.co.uk>
 * @version 2017-08-02
 */
class AddDefaultAddressToUsersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('users', function(Blueprint $table) {
            $table->integer('default_address_id')
                ->unsigned()
                ->nullable()
                ->after('password')
                ->index();
        });

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('users', function($table)
        {
            $table->dropColumn('default_address_id');
        });
    }
}
