<?php

namespace Mtc\Core\Events\Admin;

use Carbon\Carbon;

/**
 * Class FetchDashboardStats
 *
 * Event for retrieving supported Dashboard stats widgets
 *
 * @package Mtc\Core\Events\Admin
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
class FetchDashboardStats
{
    /**
     * @var \Illuminate\Support\Collection $quick_stats
     */
    public $quick_stats;

    /**
     * @var \Illuminate\Support\Collection $charts
     */
    public $charts;

    /**
     * @var Carbon $previous_period
     */
    public $previous_period;

    /**
     * @var Carbon $start
     */
    public $start;

    /**
     * @var Carbon $end
     */
    public $end;

    /**
     * FetchDashboardStats constructor.
     *
     * @param Carbon $start
     * @param Carbon $end
     * @param Carbon $previous_period
     */
    public function __construct(Carbon $start, Carbon $end, Carbon $previous_period)
    {
        $this->quick_stats = collect([]);
        $this->charts = collect([]);
        $this->start = $start;
        $this->end = $end;
        $this->previous_period = $previous_period;
    }
}