<?php
/**
 * ItemLoading Event
 *
 * PHP Version 7
 *
 * @category Mtc\Core\Events\Admin
 * @package  Mtc\Core
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */

namespace Mtc\Core\Events\Admin;

use Illuminate\Database\Eloquent\Model;

/**
 * This event is triggered when the Item is being rendered, so components are
 * able to register any blocks they need to add.
 *
 * @category Mtc\Core\Events\Admin
 * @package  Mtc\Core
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */
class ItemLoading
{
    /**
     * The model that is being loaded.
     *
     * @var null|Model
     */
    public $model = null;
    /**
     * The base name for the model being loaded.
     *
     * @var string
     */
    public $baseClass = '';

    /**
     * Store information with the event on the model and it's basename.
     *
     * @param Model $model The model that's being loaded
     *
     * @return void
     */
    public function __construct(Model $model)
    {
        $this->model = $model;
        $this->baseClass = class_basename($model);
    }
}
