<?php
/**
 * StoreUser Request
 *
 * PHP Version 7
 *
 * @category Mtc\Core\Http\Requests\Admin
 * @package  Mtc\Core\Admin
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */

namespace Mtc\Core\Http\Requests\Admin;

use Illuminate\Support\Facades\App;
use Mtc\Core\Contracts\User;
use Route;
use Illuminate\Foundation\Http\FormRequest;

/**
 * Validate an incoming request for storing users with custom rules.
 *
 * @category Mtc\Core\Http\Requests\Admin
 * @package  Mtc\Core\Admin
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */
class StoreUser extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $user_id = Route::input('user', null);
        if ($user_id) {
            $user = App::make(User::class)->findOrFail($user_id);
        }

        return [
            'name' => 'required|max:255',
            'email' => 'required|max:255|email|unique:users,email,' . (is_null($user) ? 0 : $user->id),
        ];
    }
}
