<?php
/**
 * Class AddPostcodeRegexToCountriesTable
 *
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

/**
 * Class AddPostcodeRegexToCountriesTable
 *
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 * @version 2017-06-10
 */
class AddPostcodeRegexToCountriesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('countries', function(Blueprint $table) {
            $table->string('postcode_regex')->nullable();
            $table->boolean('has_postcodes')->default(0)->index();
            $table->tinyInteger('is_eu')->default(0)->index();
        });

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('countries', function($table)
        {
            $table->dropColumn('has_postcodes');
            $table->dropColumn('postcode_regex');
            $table->dropColumn('is_eu');
        });
    }
}
