@extends('theme::layouts.public')
@section('content')
    <div class="pageWrap">

        <div class="contentPageWrap">

            @includeIf('core::layouts.partials.members_sidebar')

            <div class="contentWrap membersWrap">

                <form action="{{ $page_details['route'] }}" method="POST" class="withBackground formInline">
                    {{ csrf_field() }}
                    {{ method_field($page_details['method']) }}

                    <fieldset>
                        <div class="row {{ $errors->has('address.name') ? 'errorWrap showError' : '' }}">
                            <label for="name">{{ trans('core::fields.address.name') }}</label>
                            <div class="inputWrap">
                                <input name="address[name]" id="name"
                                       value="{{ old('address.name', $address->name) }}">
                                @include('core::public.addresses.error', ['field' => 'address.name'])
                            </div>
                        </div>
                        <div class="row {{ $errors->has('address.first_name') ? 'errorWrap showError' : '' }}">
                            <label for="first_name">{{ trans('core::fields.address.first_name') }}</label>
                            <div class="inputWrap">
                                <input name="address[first_name]" id="first_name"
                                       value="{{ old('address.first_name', $address->first_name) }}">
                                @include('core::public.addresses.error', ['field' => 'address.first_name'])
                            </div>
                        </div>
                        <div class="row {{ $errors->has('address.last_name') ? 'errorWrap showError' : '' }}">
                            <label for="last_name">{{ trans('core::fields.address.last_name') }}</label>
                            <div class="inputWrap">
                                <input name="address[last_name]" id="last_name"
                                       value="{{ old('address.last_name', $address->last_name) }}">
                                @include('core::public.addresses.error', ['field' => 'address.last_name'])
                            </div>
                        </div>

                        <address-finder :address="{{ json_encode([
                                        'address1' => old('address.address1', $address->address1),
                                        'address2' => old('address.address2', $address->address2),
                                        'city' => old('address.city', $address->city),
                                        'postcode' => old('address.postcode', $address->postcode),
                                        'state' => old('address.state', $address->state),
                                        'country' => old('address.country', $address->country),
                                    ]) }}"
                                        :errors="{{ $errors->toJson() }}"
                        ></address-finder>
                    </fieldset>
                    <button type="submit" class="button">{{ trans('core::text.save') }}</button>
                </form>
            </div>
        </div>
    </div>
@endsection
