<?php

namespace Mtc\Core\Auth;

use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Mtc\Core\Models\User\Address;
use Mtc\Core\Models\User\Token;
use Spatie\Permission\Traits\HasRoles;

class User extends Authenticatable
{
    use UserStats;
    use HasRoles;
    use Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'title',
        'company_name',
        'full_name',
        'email',
        'password',
        'default_address',
        'contact_no'
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    public function addresses()
    {
        return $this->hasMany(Address::class);
    }

    /**
     * Relationship with third party auth tokens
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function tokens()
    {
        return $this->hasMany(Token::class);
    }

    /**
     * Relationship with the default address for this user
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function defaultAddress()
    {
        return $this->belongsTo(Address::class, 'default_address_id');
    }

    /**
     * Retrieve the users first name from address book
     * @return bool|string
     */
    public function getFirstName()
    {
        // First lets use the default address for the user
        if ($this->default_adddress_id) {
            $default_address = $this->addresses()
                ->where('id', $this->default_address_id)
                ->first();

            if ($default_address) {
                return $default_address->first_name;
            }
        }


        // If billing address is not present, lets fall back to any address
        $address = $this->addresses()->first();

        return $address->first_name ?? false;

    }

    /**
     * Build the name attribute based on known information about user
     * If company name is set it will be used, then falls back to user full name
     *
     * @return string
     */
    public function getNameAttribute()
    {
        if (config('core.member.use_company_name') && !empty($this->company_name)) {
            return $this->company_name;
        }

        if (config('core.member.use_title') && !empty($this->title)) {
            return $this->title . ' ' . $this->full_name;
        }

        return $this->full_name;

    }

}
