<?php

namespace Mtc\Core;

use Illuminate\View\View;

class Form
{
    /**
     * Render form field
     *
     * @param string $type field type
     * @param array $config additional configuration
     * @return View|string
     */
    public static function field($type = 'input', $options = [])
    {
        try {
            return view("core::admin.builder.partials.{$type}")->with(compact('options'))->render();
        } catch (\Throwable $exception) {
            return '';
        }
    }

    /**
     * Render input field
     *
     * @param array $config additional configuration
     * @return View
     */
    public static function input($config = [])
    {
        return self::field('input', $config);
    }

    /**
     * Render input field
     *
     * @param array $config additional configuration
     * @return View
     */
    public static function select($config = [])
    {
        return self::field('select', $config);
    }

    /**
     * Render text area field
     *
     * @param array $config additional configuration
     * @return View
     */
    public static function textarea($config = [])
    {
        return self::field('textarea', $config);
    }

    /**
     * Render radio input field
     *
     * @param array $config additional configuration
     * @return View
     */
    public static function radio($config = [])
    {
        return self::field('radio', $config);
    }

    /**
     * Render radio input field
     *
     * @param array $config additional configuration
     * @return View
     */
    public static function checkbox($config = [])
    {
        return self::field('checkbox', $config);
    }

    /**
     * Render file input field
     *
     * @param array $config additional configuration
     * @return View
     */
    public static function file($config = [])
    {
        return self::field('file', $config);
    }


}