<?php
/**
 * Members Dashboard controller
 *
 * @package Mtc\Core
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk
 */

namespace Mtc\Core\Http\Controllers\Members;

use Illuminate\Support\Facades\Auth;
use Mtc\Core\Http\Controllers\Controller;

/**
 * Members Dashboard controller
 *
 * @package Mtc\Core
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk
 */
class DashboardController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * Adds requirement for logging in as middleware and adds breadcrumbs
     */
    public function __construct()
    {
        parent::__construct();
        $this->middleware('auth');
        // Add Breadcrumbs
        $this->breadcrumbs->addCrumb(
            ucwords(__('core::text.members_area')),
            action('\\' . DashboardController::class . '@index')
        );
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('core::public.members.dashboard', [
            'user' => Auth::user()
        ]);
    }

}
