/**
 * Public JS Loader
 *
 * This is used to load up any JS dependencies and components to the public interface
 *
 * @author Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */

window.swal = require('sweetalert2');

// Add modal support for vue
import vmodal from 'vue-js-modal';

require('./vue_filters');
Vue.use(vmodal);

Vue.component('breadcrumbs', require('./components/public/breadcrumbs.vue'));
Vue.component('delete', require('./components/public/delete.vue'));
Vue.component('login-button', require('./components/public/login_button.vue'));
Vue.component('login-popup', require('./components/public/login_popup.vue'));
Vue.component('login-menu-item', require('./components/public/login_menu_item.vue'));
Vue.component('address-book', require('./components/public/address_book.vue'));
Vue.component('address-form', require('./components/public/address_form.vue'));
Vue.component('change-password', require('./components/public/change-password.vue'));
Vue.component('address-finder', require('./components/public/address_finder.vue'));
Vue.component('input-text', require('./components/public/input_text.vue'));
Vue.component('input-checkbox', require('./components/public/input_checkbox.vue'));
Vue.component('input-select', require('./components/public/input_select.vue'));

window.dispatchListener = new Vue();
