<div class="form-group">
    @if (!empty($options['label']))
        <label for="{{ $options['id'] }}">
            {{ trans($options['label']) }}
        </label>
    @endif
    @foreach ($options['values'] as $value => $name)
        <div class="form-check">
            <input type="checkbox"
                   name="{{ $options['name'] }}{{ !empty($options['multiple']) ? '[]' : '' }}"
                   id="{{ $options['id'] }}_{{ $value }}"
                   class="{{ !empty($options['class']) ? $options['class'] : '' }}"
                   placeholder="{{ !empty($options['placeholder']) ? trans($options['placeholder']) : '' }}"
                   value="{{ $value }}"
                @if (!empty($options['multiple']))
                    @if (!empty($options['object']->{$options['field_name']}))
                        {{ in_array($value, Request::old($options['old_value'], $options['object']->{$options['field_name']})) ? 'checked' : '' }}
                    @endif
                @else
                    {{ Request::old($options['old_value'], $options['object']->{$options['field_name']}) == $value ? 'checked' : '' }}
                @endif
            />

            <label for="{{ $options['id'] }}_{{ $value }}">
                {{ trans($name) }}
            </label>
        </div>
    @endforeach
    @include('core::layouts.partials.admin.field_error', ['field' => $options['old_value']])
</div>