<div class="{{ empty($skip_well) ? 'well' : '' }}">
    {!!
        Mtc\Core\Form::input([
            'translate' => true,
            'label' => 'fields.title',
            'field_name' => 'title',
            'id' => 'node_title',
            'name' => 'node[title]',
            'placeholder' => 'fields.title',
            'old_value' => 'node.title',
            'object' => $node
        ])
    !!}

    @if (empty($hide_description))
        {!!
            Mtc\Core\Form::textarea([
                'tinymce' => true,
                'translate' => true,
                'label' => 'fields.description',
                'field_name' => 'description',
                'id' => 'node_description',
                'name' => 'node[description]',
                'old_value' => 'node.description',
                'object' => $node
            ])
        !!}
    @endif

    <div class="form-group">
        <label for="node_status">{{ trans('fields.status') }}</label>
        <select name="node[status]"
            class="form-control"
            id="node_status"
            >
            {{-- @todo: Will replace with a config/event --}}
            @foreach(['published', 'draft'] as $status)
                <option value="{{ $status }}"
                    {{ $status == $node->status ? 'selected' : ''}}
                    >{{ trans('fields.status_options.' . $status) }}
                </option>
            @endforeach
        </select>
    </div>

    @if (empty($hide_visibility))
        <div class="form-group">
            <label for="node_visibility">{{ trans('fields.visibility') }}</label>
            <select name="node[visibility]"
                class="form-control"
                id="node_visibility"
                >
                {{-- @todo: Will replace with a config/event --}}
                @foreach(['public', 'private'] as $visibility)
                    <option value="{{ $visibility }}"
                        {{ $visibility == $node->visibility ? 'selected' : ''}}
                        >{{ trans('fields.visibility_options.' . $visibility) }}
                    </option>
                @endforeach
            </select>
        </div>
    @endif

    @if (!empty($show_featured) || ($item && !empty($item->can_be_featured)))
        <div class="form-group">

            {!!
                Mtc\Core\Form::checkbox([
                    'field_name' => 'featured',
                    'id' => 'node_featured',
                    'name' => 'node[featured]',
                    'old_value' => 'node.featured',
                    'object' => $node,
                    'values' => [
                        1 => __('core::fields.featured')
                    ]
                ])
            !!}
        </div>
    @endif
</div>
