@if (!empty($options['translate']))
    @foreach($enabled_languages as $language)
        <div class="form-group translatable" data-language="{{ $language }}">
            <label for="{{ $options['id'] }}_{{ $language }}">
                {{ trans($options['label']) }} ({{ $language }})
            </label>
            <textarea class="form-control {{ !empty($options['class']) ? $options['class'] : '' }} {{ !empty($options['tinymce']) ? 'tinymce' : '' }}"
                      name="{{ $options['name'] }}[{{ $language }}]"
                      id="{{ $options['id'] }}_{{ $language }}"
            >{{ Request::old($options['old_value'] . '.' . $language, $options['object']->getTranslation($options['field_name'], $language)) }}</textarea>
            @include('core::layouts.partials.admin.field_error', ['field' => $options['old_value']])
        </div>
    @endforeach
@else
    <div class="form-group">
        <label for="{{ $options['id'] }}">
            {{ trans($options['label']) }}
        </label>
        <textarea class="form-control {{ !empty($options['class']) ? $options['class'] : '' }} {{ !empty($options['tinymce']) ? 'tinymce' : '' }}"
                  name="{{ $options['name'] }}"
                  id="{{ $options['id'] }}"
        >{{ Request::old($options['old_value'], $options['object']->{$options['field_name']}) }}</textarea>
        @include('core::layouts.partials.admin.field_error', ['field' => $options['old_value']])
    </div>
@endif