<div class="form-horizontal">

    <div class="form-group">
        <label for="url" class="col-sm-1 control-label">
            {{ trans('core::fields.url') }}
        </label>
        <div class="col-sm-10">
            <input type="text"
                   class="form-control"
                   name="url"
                   id="url"
                   placeholder="{{ trans('core::fields.url') }}"
                   value="{{ Request::old('url', $item->url) }}"
            />
            @include('core::layouts.partials.admin.field_error', ['field' => 'url'])
        </div>
    </div>

    <word-counter limit="60"
                  value="{{ Request::old('title', $item->title) }}"
                  inline-template>
        <div class="form-group">
            <label for="title" class="col-sm-1 control-label">
                {{ trans('fields.title') }}
            </label>
            <div class="col-sm-10">
                <input type="text"
                       class="form-control"
                       :class="{
                            'hasWarning' : has_warning,
                            'hasError' : has_error,
                       }"
                       v-model="field"
                       :maxlength="limit"
                       name="title"
                       id="title"
                       placeholder="{{ trans('fields.title') }}"
                       value="{{ Request::old('title', $item->title) }}"
                />
                @include('core::layouts.partials.admin.field_error', ['field' => 'title'])
            </div>
            <div class="col-sm-1" v-cloak>
                (@{{ field.length }} / @{{ limit }})
            </div>
        </div>
    </word-counter>

    <word-counter limit="160"
                  value="{{ Request::old('description', $item->description) }}"
                  inline-template>
        <div class="form-group">
            <label for="description" class="col-sm-1 control-label">
                {{ trans('fields.description') }}
            </label>
            <div class="col-sm-10">
                <input type="text"
                       class="form-control"
                       :class="{
                            'hasWarning' : has_warning,
                            'hasError' : has_error,
                       }"
                       v-model="field"
                       :maxlength="limit"
                       name="description"
                       id="description"
                       placeholder="{{ trans('fields.description') }}"
                       value="{{ Request::old('description', $item->description) }}"
                />
                @include('core::layouts.partials.admin.field_error', ['field' => 'description'])
            </div>
            <div class="col-sm-1" v-cloak>
                (@{{ field.length }} / @{{ limit }})
            </div>
        </div>
    </word-counter>

    <div class="form-group">
        <label for="h1" class="col-sm-1 control-label">
            {{ trans('core::fields.h1') }}
        </label>
        <div class="col-sm-10">
            <input type="text"
                   class="form-control"
                   name="h1"
                   id="h1"
                   placeholder="{{ trans('core::fields.h1') }}"
                   value="{{ Request::old('h1', $item->h1) }}"
            />
            @include('core::layouts.partials.admin.field_error', ['field' => 'h1'])
        </div>
    </div>

</div>