@extends('theme::layouts.public')
@section('content')

    <div class="pageWrap">

        <div class="contentPageWrap">

            @includeIf('core::layouts.partials.members_sidebar')

            <div class="contentWrap membersWrap">
                @includeIf('core::layouts.partials.session_messages')

                <h3>{{ __('core::fields.user_details.details') }}</h3>

                <form method="post"
                      action="{{ route('core.member.details.store') }}">
                    {{ csrf_field() }}
                    <fieldset class="memberEditContact">

                        <p>{{ __('core::text.enter_contact_details') }}</p>

                        @if (config('core.member.use_company_name'))
                            <div class="row{{ $errors->has('name') ? ' inputError' : '' }}">
                                <label for="company_name">{{ __('core::fields.company_name') }}</label>
                                <div class="inputWrap">
                                    <input type="text"
                                           name="company_name"
                                           class="text"
                                           id="company_name"
                                           value="{{ old('company_name', $user->company_name) }}"/>
                                    @include('core::layouts.partials.error_message', ['errors' => $errors->get('company_name')])
                                </div>
                            </div>
                        @endif

                        @if (config('core.member.use_title'))
                            <div class="row{{ $errors->has('title') ? ' inputError' : '' }}">
                                <label for="title">{{ __('core::fields.title') }}</label>
                                <div class="inputWrap">
                                    <select name="title" id="title">
                                        <option value="">{{ __('core::fields.choose_title') }}</option>
                                        @foreach (config('core.member.titles') as $title)
                                            <option value="{{ $title }}" {{ old('title', $user->title) == $title ? 'selected' : '' }}>
                                                {{ __("core::fields.titles.{$title}") }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @include('core::layouts.partials.error_message', ['errors' => $errors->get('title')])
                                </div>
                            </div>
                        @endif

                        <div class="row{{ $errors->has('name') ? ' inputError' : '' }}">
                            <label for="full_name">{{ __('core::fields.name') }}<sup>*</sup></label>
                            <div class="inputWrap">
                                <input type="text"
                                       name="full_name"
                                       class="text"
                                       id="full_name"
                                       value="{{ old('full_name', $user->full_name) }}"/>
                                @include('core::layouts.partials.error_message', ['errors' => $errors->get('full_name')])
                            </div>
                        </div>

                        <div class="row {{ $errors->has('email') ? 'errorWrap showError' : '' }}">
                            <label for="email">{{ __('core::fields.email') }}<sup>*</sup></label>
                            <div class="inputWrap">
                                <input type="email"
                                       id="email"
                                       name="email"
                                       value="{{ $user->email }}"
                                       class="text"/>
                                @include('core::layouts.partials.error_message', ['errors' => $errors->get('email')])
                            </div>
                        </div>

                        <div class="row {{ $errors->has('contact_no') ? 'errorWrap showError' : '' }}">
                            <label for="contactNo">{{ __('core::fields.contact_no') }}</label>
                            <div class="inputWrap">
                                <input type="text"
                                       id="contactNo"
                                       name="contact_no"
                                       value="{{ $user->contact_no }}"
                                       class="text"/>
                                @include('core::layouts.partials.error_message', ['errors' => $errors->get('contact_no')])
                            </div>
                        </div>
                    </fieldset>

                    <fieldset>

                        <h6>{{ __('core::fields.user_details.change_password') }}</h6>
                        <p>{{ __('core::text.change_password_text') }}</p>
                        <change-password></change-password>
                        @include('core::layouts.partials.error_message', ['errors' => $errors->get('password')])
                    </fieldset>

                    <div class="row" id="changeDetailsSubmit">
                        <input type="hidden" name="action" value="update"/>
                        <button type="submit"
                                name="submit['change_details']"
                                class="button rollover">
                            {{ __('core::fields.user_details.change_details') }} <i class="fa fa-angle-right"></i>
                        </button>
                    </div>
                </form>


                <h3>{{ __('core::fields.user_details.address_book') }}</h3>
                @if (count($addresses))
                    <table class="alternating">
                        <thead>
                        <tr>
                            <th>{{ __('core::fields.address.name') }}</th>
                            <th>{{ __('core::fields.address.default') }}</th>
                            <th>{{ __('core::fields.address.address1') }}</th>
                            <th>{{ __('core::fields.address.city') }}</th>
                            <th>{{ __('core::fields.address.postcode') }}</th>
                            <th colspan="2">{{ __('core::fields.address.actions') }}</th>
                        </tr>
                        </thead>
                        <tbody>
                        @foreach($addresses as $address)
                            <tr>
                                <td>
                                    {{ $address->name }}
                                </td>
                                <td>

                                    @if(Auth::user()->default_address_id == $address->id)
                                        <i class="fa fa-check"></i>
                                    @else
                                        <td>
                                            <form method="post"
                                                  action="{{ route('core.member.addresses.default', $address->id) }}">
                                                {{ csrf_field() }}
                                                <input name="id" value="{{ $address->id }}" type="hidden">
                                                <button id="set-address-default"
                                                        class="button buttonSmall">{{ __('core::text.set_as_default') }}</button>
                                            </form>
                                        </td>
                                    @endif
                                <td>{{ $address->address1 }}</td>
                                <td>{{ $address->city }}</td>
                                <td>{{ $address->postcode }}</td>
                                <td>
                                    <a href="{{ route('core.member.addresses.edit', $address->id) }}"
                                       class="button buttonSmall">{{ __('core::text.edit') }}</a>
                                </td>
                                <td>
                                    <delete action="{{ route('core.member.addresses.destroy', $address->id) }}"
                                            redirect="{{ route('core.member.details.index') }}"
                                            text="{{ __('core::text.delete') }}"></delete>
                                </td>
                            </tr>
                        @endforeach
                        </tbody>
                    </table>
                @endif
                <div>
                    <a class="button buttonSmall"
                       href="{{ route('core.member.addresses.create') }}">{{ __('core::text.create_new_address') }}</a>
                </div>
            </div> <!-- .contentWrap.membersWrap -->

        </div> <!-- .contentPageWrap -->

    </div> <!-- .pageWrap -->
@endsection
