<?php

namespace Mtc\Core\Http\Controllers\Auth;

use Illuminate\Http\Request;
use Mtc\Core\Http\Controllers\Controller;
use Illuminate\Foundation\Auth\AuthenticatesUsers;

class LoginController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Login Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles authenticating users for the application and
    | redirecting them to your home screen. The controller uses a trait
    | to conveniently provide its functionality to your applications.
    |
    */

    use AuthenticatesUsers;

    /**
     * Where to redirect users after login.
     *
     * @var string
     */
    protected $redirectTo = '/';

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
        $this->breadcrumbs->addCrumb(trans('core::text.login'), '');
        $this->middleware('guest', ['except' => 'logout']);
    }

    /**
     * The user has been authenticated.
     *
     * @param  \Illuminate\Http\Request $request
     * @param  mixed $user
     * @return mixed
     */
    protected function authenticated(Request $request, $user)
    {
        if ($request->wantsJson() && $request->user()) {
            return [
                'status' => 'ok',
                'user' => $request->user(),
                'admin_access' => $request->user()->can('admin')
            ];
        }

        if (config('app.redirect_to_admin_after_login') && $request->user() && $request->user()->can('admin')) {
            return redirect(action('\\' . \Mtc\Core\Http\Controllers\Admin\HomeController::class . '@index'));
        }
    }
}
