<?php
/**
 * Class Seo\Setting
 *
 * @package Mtc\Core
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
namespace Mtc\Core\Models\Seo;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Cache;

/**
 * Class Seo\Setting
 *
 * Seo Setting model
 * Used to store seo specific settings like Analytics keys etc.
 *
 * @package Mtc\Core
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
class Setting extends Model
{

    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'seo_settings';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'key',
        'value',
        'description'
    ];

    /**
     * Boot the model
     */
    public static function boot()
    {
        parent::boot();

        // Make sure we clear this key from cache
        static::saved(function ($setting) {
            Cache::forget($setting->key);
        });
    }
}
