<?php
/**
 * Member Dashboard Tests
 *
 * @category Mtc\Core\Tests
 * @package  Mtc\Core
 * @author Martins Fridenbergs <martins.fridenbergs@gmail.com>
 */

use Illuminate\Foundation\Testing\DatabaseTransactions;
use Mtc\Core\Auth\User;

/**
 * Member Dashboard Tests
 *
 * Ensure the functionality for members dashboard is functional
 *
 * @category Mtc\Shop\Tests
 * @package Mtc\Shop
 * @author Martins Fridenbergs <martins.fridenbergs@gmail.com>
 */
class MemberDashboardTest extends \Tests\TestCase
{
    use DatabaseTransactions;

    /**
     * Make sure that logged in user can view their dashboard
     */
    public function testCanLoadDashboardPageAsMember()
    {
        $this->actingAs(User::first())
            ->get(route('core.member.dashboard'))
            ->assertStatus(200);
    }

    /**
     * Make sure unauthorized users cannot access dashboard
     */
    public function testCannotLoadDashboardPageAsGuest()
    {
        $this->get(route('core.member.dashboard'))
            ->assertRedirect(route('login'));
    }

    /**
     * Test that members dashboard links event returns entries (including editing details)
     */
    public function testMemberNavigationIsValid()
    {
        $navigation = collect(event('members.dashboard'));
        $this->assertTrue($navigation->count() > 0);

        $details_exist_in_nav = $navigation->where('url', route('core.member.details.index'))->count() > 0;
        $this->assertTrue($details_exist_in_nav);
    }
}