@if (!empty($options['translate']))
    @foreach($enabled_languages as $language)
        <div class="form-group translatable" data-language="{{ $language }}">
            <label for="{{ $options['id'] }}_{{ $language }}">
                {{ trans($options['label']) }} ({{ $language }})
            </label>
            <input type="text"
                   {{ !empty($options['disabled']) ? 'disabled' : '' }}
                   name="{{ $options['name'] }}[{{ $language }}]"
                   id="{{ $options['id'] }}_{{ $language }}"
                   class="form-control {{ !empty($options['class']) ? $options['class'] : '' }}"
                   placeholder="{{ !empty($options['placeholder']) ?  trans($options['placeholder']) : '' }}"
                   value="{{ Request::old($options['old_value'] . '.' . $language, $options['object']->getTranslation($options['field_name'], $language)) }}"
            />
            @include('core::layouts.partials.admin.field_error', ['field' => $options['old_value']])
        </div>
    @endforeach
@else
    <div class="form-group">
        <label for="{{ $options['id'] }}">
            {{ trans($options['label']) }}
        </label>
        <input type="text"
               name="{{ $options['name'] }}"
               {{ !empty($options['disabled']) ? 'disabled' : '' }}
               id="{{ $options['id'] }}"
               class="form-control {{ !empty($options['class']) ? $options['class'] : '' }}"
               placeholder="{{ !empty($options['placeholder']) ?  trans($options['placeholder']) : '' }}"
               value="{{ Request::old($options['old_value'], $options['object']->{$options['field_name']}) }}"
        />
        @include('core::layouts.partials.admin.field_error', ['field' => $options['old_value']])
    </div>
@endif