<?php
/**
 * Api User Controller
 *
 * @package Mtc\Core
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk
 */
namespace Mtc\Core\Api\Controllers;

use Illuminate\Http\Request;
use Mtc\Core\Http\Controllers\Controller;

/**
 * Admin dashboard controller
 *
 * Admin landing page controller
 *
 * @package Mtc\Core
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk
 * @version 2017-06-17
 */
class UserController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
        $this->middleware('auth');
    }

    /**
     * Return current user
     *
     * @param Request $request incoming request
     * @return mixed current user as json response
     */
    public function show(Request $request)
    {
        return $request->user();
    }
}
