<?php
/**
 * User Address Model
 *
 * PHP Version 7
 *
 * @category Mtc\Core
 * @package  Mtc\Core
 * @author   James Neill <james.neill@mtcmedia.co.uk>
 */
namespace Mtc\Core\Models\User;

use Illuminate\Database\Eloquent\Model;
use Mtc\Core\Auth\User;
use Mtc\Core\Traits\AddressValidator;

/**
 * Model storing information about a user's address.
 *
 * PHP Version 7
 *
 * @category Mtc\Core
 * @package  Mtc\Core
 * @author   James Neill <james.neill@mtcmedia.co.uk>
 */
class Address extends Model
{
    use AddressValidator;

    protected $table = 'user_addresses';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'user_id',
        'name',
        'full_name',
        'first_name',
        'last_name',
        'address1',
        'address2',
        'city',
        'state',
        'postcode',
        'country'
    ];

    /**
     * Get the associated user
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
