<?php
/**
 * Class CurrencySeeder
 *
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 * @version 2017-05-30
 */

use Illuminate\Database\Seeder;
use Mtc\Core\Models\Currency;

/**
 * Class CurrencySeeder
 *
 * Seed the database with default currencies for site
 *
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 * @version 2017-05-30
 */
class CurrencySeeder extends Seeder
{

    /**
     * @var array $default_currencies currencies that are seeded by default
     */
    private static $default_currencies = [
        [
            'code' => 'EUR',
            'rate' => 1.1469,
            'active' => 0,
            'locale' => 'de_DE.UTF-8'
        ],
        [
            'code' => 'GBP',
            'rate' => 1.0,
            'active' => 1,
            'locale' => 'en_GB.UTF-8'
        ],
        [
            'code' => 'USD',
            'rate' => 1.2841,
            'active' => 0,
            'locale' => 'en_US.UTF-8'
        ],
        [
            'code' => 'JPY',
            'rate' => 142.65,
            'active' => 0,
            'locale' => 'ja_JP.UTF-8'
        ],
        [
            'code' => 'RUB',
            'rate' => 73.17,
            'active' => 0,
            'locale' => 'ru_RU.UTF-8'
        ],
    ];

    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // Loop through all currencies and set them if they don't exist
        foreach (self::$default_currencies as $currency) {
            if (Currency::where('code', $currency['code'])->count() == 0) {
                Currency::create($currency);
            }
        }
    }
}
