@extends('core::layouts.admin')

@section('title', ($item->exists ? 'Edit ' : 'Add ') . (!empty($title) ? ucfirst(trans($title)) :  ucfirst(str_singular($name))))

@section('content')

    <form method="POST" action="{{ $form_action }}" enctype="multipart/form-data">

        <div class="well well-sm">
            <button type="submit"
                    class="btn btn-success"
                    >Save</button>
        </div>

        @include('core::admin.builder.partials.errors')

        @include('core::admin.builder.partials.tabs')

        @if (!is_null($node))
            @include('core::admin.builder.partials.node')
        @endif


        @if (!empty($view))
            <div class="well">
                @include($view)
            </div>
        @endif

        @if (!is_null($node))
            <custom-node node-in="{{ $node }}" class-name="{{ get_class($item) }}" css-class="well" v-cloak></custom-node>
        @endif

        {{-- Allow custom HTML form other components --}}
        @foreach (event(new \Mtc\Core\Events\Admin\ItemLoading($item)) as $response)
            {!! $response !!}
        @endforeach

        <div class="well well-sm">
            <button type="submit"
                    class="btn btn-success"
                    >Save</button>
            <div class="pull-right">
                <a class="btn btn-default" href="#top">Back to Top</a>
            </div>
        </div>

        {{ method_field($form_method) }}
        {{ csrf_field() }}
    </form>

@endsection
