@extends('theme::layouts.public')
@section('content')
    <div class="pageWrap">

        <div class="contentPageWrap">

            @includeIf('core::layouts.partials.members_sidebar')

            <div class="contentWrap membersWrap">

                <h2>{{ __('core::fields.hello_user', [ 'user' => $user->name ]) }}</h2>

                <p>{{ __('core::text.members_welcome_back') }}</p>

                <div class="memberLinks">
                    @foreach(event('members.dashboard') as $link)

                        <div class="memberLink">
                            <a href="{{ $link['url'] }}">
                                @if (!empty($link['icon']))
                                    <i class="fa {{ $link['icon'] }}"></i>
                                @endif
                                <h6>
                                    {{ $link['title'] }}
                                </h6>
                                <span>{{ $link['subtitle'] ?? '' }}</span>
                            </a>
                        </div> <!-- .memberLink -->
                    @endforeach

                    <div class="memberLink">
                        <a href="{{ url('/logout') }}">
                            <i class="fa fa-sign-out"></i>
                            <h6>
                                {{ __('core::fields.logout') }}
                            </h6>
                            <span>{{ __('core::fields.logout') }}</span>
                        </a>
                    </div> <!-- .memberLink -->

                </div> <!-- .memberLinks -->

            </div> <!-- .contentWrap.membersWrap -->

        </div> <!-- .contentPageWrap -->

    </div> <!-- .pageWrap -->
@endsection
