<?php

namespace Mtc\Core;

use Illuminate\Database\Eloquent\Model;

/**
 * Email Template Eloquent Model
 *
 * @category Mtc\Core
 * @package Mtc\Core
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
class EmailTemplate extends Model
{
    /**
     * Mass assignable attributes
     *
     * @var string[]
     */
    protected $fillable = [
        'title',
        'subject',
        'model_id',
        'model_type',
        'layout',
        'active',
        'content'
    ];

    /**
     * Relationship with the owner of the email template
     *
     * @return \Illuminate\Database\Eloquent\Relations\MorphTo
     */
    public function model()
    {
        return $this->morphTo();
    }

}
