<?php
/**
 * Core View Composer Service Provider
 *
 * PHP Version 7
 *
 * @category Mtc\Core\Providers
 * @package  Mtc\Core\Admin
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */

namespace Mtc\Core\Providers;

use Illuminate\Support\Facades\View;
use Illuminate\Support\ServiceProvider;
use Mtc\Core\Http\Controllers\CurrencyController;
use Mtc\Core\Http\ViewComposers\CurrencyComposer;
use Mtc\Core\Http\ViewComposers\RolesPermissionsComposer;
use Mtc\Core\Http\ViewComposers\SeoComposer;

/**
 * Registers view composers for any views.
 *
 * @category Mtc\Core\Providers
 * @package  Mtc\Core\Admin
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */
class ComposerServiceProvider extends ServiceProvider
{
    /**
     * Register any events for your application.
     *
     * @return void
     */
    public function boot()
    {
        View::composer('core::admin.user.form', RolesPermissionsComposer::class);
        View::composer('core::admin.role.form', RolesPermissionsComposer::class);
        // All requests go through Seo
        View::composer('*', SeoComposer::class);
        View::composer('theme::layouts.public', CurrencyComposer::class);
    }

    /**
     * Register the service provider.
     *
     * @return void
     */
    public function register()
    {
        //
    }
}
