<?php
/**
 * Member Details Tests
 *
 * @category Mtc\Core\Tests
 * @package Mtc\Core
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk
 */

use Illuminate\Foundation\Testing\DatabaseTransactions;
use Illuminate\Support\Facades\Validator;
use Mtc\Core\Auth\User;

/**
 * Member Details Tests
 *
 * Ensure the functionality for updating user details is functional
 *
 * @category Mtc\Core\Tests
 * @package Mtc\Core
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk
 */
class MemberDetailsTest extends \Tests\TestCase
{
    use DatabaseTransactions;

    /**
     * Make sure that logged in user can view their past orders section
     */
    public function testCanLoadDetailsPageAsMember()
    {
        $this->actingAs(User::first())
            ->get(route('core.member.details.index'))
            ->assertStatus(200);
    }

    /**
     * Make sure unauthorized users cannot access Past order section
     */
    public function testCannotDetailsPageAsGuest()
    {
        $this->get(route('core.member.details.index'))
            ->assertRedirect(route('login'));
    }

    /**
     * Test that password validation rule rejects weak passwords
     */
    public function testWeakPasswordValidation()
    {
        $validation = Validator::make([
            'password' => 'test',
            'password_confirmation' => 'test'
        ], [
            'password' => 'required|password|confirmed',
        ]);

        $this->assertTrue($validation->fails());
    }

    /**
     * Test that password validation allows good strength passwords
     */
    public function testStrongPasswordValidation()
    {
        $validation = Validator::make([
            'password' => 'StrongPassword123$',
            'password_confirmation' => 'StrongPassword123$'
        ], [
            'password' => 'required|password|confirmed',
        ]);

        $this->assertFalse($validation->fails());
    }
}