<div class="form-horizontal">

    <div class="form-group">
        <label for="code" class="col-sm-1 control-label">
            {{ trans('core::fields.currency_code') }}
        </label>
        <div class="col-lg-2 col-sm-11">
            <select name="code"
                    id="code"
                    {{ $item->id ? 'disabled' : '' }}
                    class="form-control">
                @foreach ($supported_currencies as $currency)
                    <option value="{{ $currency }}" {{ $item->code === $currency ? 'selected' : '' }}>
                        {{ $currency }}
                    </option>
                @endforeach
            </select>
        </div>
    </div>

    <div class="form-group">
        <label for="locale" class="col-sm-1 control-label">
            {{ trans('core::fields.locale') }}
        </label>
        <div class="col-sm-11">
            <input type="text"
                   class="form-control"
                   name="locale"
                   id="locale"
                   placeholder="{{ trans('core::fields.locale_placeholder') }}"
                   value="{{ Request::old('locale', $item->locale) }}"
            />
            @include('core::layouts.partials.admin.field_error', ['field' => 'locale'])
        </div>
    </div>

    <div class="form-group">
        <label for="active" class="col-sm-1 control-label">
            {{ trans('core::fields.is_active') }}
        </label>
        <div class="col-lg-2 col-sm-11">
            <select name="active"
                    id="active"
                    class="form-control">
                <option value="1" {{ $item->active ? 'selected' : '' }}>
                    {{ trans('core::fields.yes') }}
                </option>
                <option value="0" {{ $item->active ? '' : 'selected' }}>
                    {{ trans('core::fields.no') }}
                </option>
            </select>
        </div>
    </div>

</div>