<div class="form-horizontal">

    <div class="form-group">
        <label for="name" class="col-sm-1 control-label">
            {{ trans('fields.name') }}
        </label>
        <div class="col-sm-11">
            <input type="text"
                class="form-control"
                name="name"
                id="name"
                placeholder="{{ trans('fields.name') }}"
                value="{{ Request::old('name', $item->name) }}"
                />
            @include('core::layouts.partials.admin.field_error', ['field' => 'name'])
        </div>
    </div>

    <div class="form-group">
        <label for="email" class="col-sm-1 control-label">
            {{ trans('fields.email') }}
        </label>
        <div class="col-sm-11">
            <input type="email"
                class="form-control"
                name="email"
                id="email"
                placeholder="{{ trans('fields.email') }}"
                value="{{ Request::old('email', $item->email) }}"
                />
            @include('core::layouts.partials.admin.field_error', ['field' => 'email'])
        </div>
    </div>

    <div class="form-group">
        <label for="role" class="col-sm-1 control-label">
            {{ trans('fields.role') }}
        </label>
        <div class="col-sm-11">
            <select name="roles[]" id="role" class="form-control" multiple>
            @foreach ($roles as $role)
                <option value="{{ $role->id }}"
                    {{ $item->roles->where('id', '=', $role->id)->isEmpty() ? '' : 'selected' }}
                    >{{ $role->name }}</option>
                    }
            @endforeach
            </select>
            @include('core::layouts.partials.admin.field_error', ['field' => 'roles'])
        </div>
    </div>

</div>
