<?php

namespace Mtc\Core\Console;

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;
use Mtc\Core\Events\ScheduleAdditionalTasks;

class Kernel extends ConsoleKernel
{
    /**
     * The Artisan commands provided by your application.
     *
     * @var array
     */
    protected $commands = [
        Commands\Install::class,
        Commands\GenerateSitemap::class,
    ];

    /**
     * Define the application's command schedule.
     *
     * @param  \Illuminate\Console\Scheduling\Schedule  $schedule
     * @return void
     */
    protected function schedule(Schedule $schedule)
    {
        event(new ScheduleAdditionalTasks($schedule));

        // Make sure currencies are up to date
        if (config('core.currencies_enabled')) {
            $schedule->command('currencies:update')->dailyAt('6:00');
        }

        if (config('core.generate_sitemap') && $this->app->environment('production') !== false) {
            $schedule->command('sitemap:generate')->dailyAt('3:00');
        }
    }

    /**
     * Register the Closure based commands for the application.
     *
     * @return void
     */
    protected function commands()
    {
        require base_path('routes/console.php');
    }
}
