<?php
/**
 * Sitemap Generated event
 *
 * PHP Version 7
 *
 * @category Mtc\Shop\Events
 * @package  Mtc\Shop
 * @author   Uldis Zvirbulis <uldis.zvirbulis@mtcmedia.co.uk>
 */

namespace Mtc\Core\Events;

use Mtc\Core\Console\Commands\GenerateSitemap;

/**
 * Sitemap Generated event. Fired when sitemap is done in Core.
 *
 * @category Mtc\Shop\Events
 * @package  Mtc\Shop
 * @author   Uldis Zvirbulis <uldis.zvirbulis@mtcmedia.co.uk>
 */
class SitemapGenerated
{
    /**
     *
     * @var null|GenerateSitemap
     */
    public $generate_sitemap;

    /**
     * Build the new event, adding in the Sitemap Generator.
     *
     * @param GenerateSitemap $generate_sitemap
     *
     */
    public function __construct(GenerateSitemap $generate_sitemap)
    {
        $this->generate_sitemap = $generate_sitemap;
    }
}
