<?php
/**
 * Taxonomy Eloquent Model
 *
 * PHP Version 7
 *
 * @category Mtc\Core
 * @package  Mtc\Core
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */

namespace Mtc\Core;

use Cache;
use Mtc\Core\Nodeable;

/**
 * Taxonomy Eloquent Model
 *
 * @category Mtc\Core
 * @package  Mtc\Core
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */

class Taxonomy extends \Baum\Node
{

    use Nodeable;

    /**
     * Table name.
     *
     * @var string
     */
    protected $table = 'taxonomies';

    /**
     * Parent timestamps which should be updated on save.
     *
     * @var array
     */
    protected $touches = ['node'];

    /**
     * Register a custom save event in order to create related node and
     * refresh taxonomy cache.
     *
     * @return void
     */
    public static function boot()
    {
        parent::boot();

        static::saved(
            function ($taxonomy) {

                if ($taxonomy->node === null) {
                    $taxonomy->node()->create(
                        [
                        'title' => $taxonomy->title,
                        'status' => 'published'
                        ]
                    );
                } else {
                    $taxonomy->node->title = $taxonomy->title;
                    $taxonomy->save();
                }

                $root = $taxonomy->getRoot();

                // Clear the root node's cache.
                Cache::forget("taxonomy:{$root->id}");

            }
        );
    }

    /**
     * Get the related nodes through the node_taxonomy table
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsToMany
     */
    public function nodes()
    {
        return $this->belongsToMany(Node::class);
    }
}
