<div class="form-horizontal">

    <div class="form-group">
        <label for="name" class="col-sm-1 control-label">
            {{ trans('fields.name') }}
        </label>
        <div class="col-sm-11">
            <input type="text"
                class="form-control"
                name="name"
                id="name"
                placeholder="{{ trans('fields.name') }}"
                value="{{ Request::old('name', $item->name) }}"
                />
            @include('core::layouts.partials.admin.field_error', ['field' => 'name'])
        </div>
    </div>

</div>

@if (! $permission_groups->isEmpty())
    <h3>{{ trans('core::fields.role_permissions') }}</h3>

    @foreach ($permission_groups as $group_name => $permissions)
        @if ($permissions->count() > 0)
            <h4>
                <a href="#" data-toggle="collapse" data-target="#{{ $group_name }}">
                    {{ ucwords($group_name) }}
                </a>
            </h4>

            <div id="{{ $group_name }}" class="collapse">
                @foreach ($permissions as $permission)
                    <div class="form-group">
                        <div class="checkbox">
                            <label>
                                <input type="checkbox"
                                    name="permissions[]"
                                    aria-describedby="permissions_{{ $permission->id }}"
                                    {{ $item->permissions->where('id', '=', $permission->id)->isEmpty() ? '' : 'checked' }}
                                    value="{{ $permission->id }}">
                                {{ $permission->display_name }} <em class="text-info small">({{ $permission->name }})</em>
                            </label>
                            <span id="permissions_{{ $permission->id }}" class="help-block">
                                {{ $permission->description }}
                            </span>
                        </div>
                    </div>
                @endforeach
            </div>
        @endif
    @endforeach
@endif
