<?php
/**
 * Contract which defines the interface the class must adhere to to be a tab,
 * allowing custom implementations when necessary.
 *
 * PHP Version 7
 *
 * @category Mtc\Core\Admin
 * @package  Mtc\Core
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */

namespace Mtc\Core\Contracts;

/**
 * Contract which defines the interface the class must adhere to to be a tab,
 * allowing custom implementations when necessary.
 *
 * @category Mtc\Core\Admin
 * @package  Mtc\Core
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */
interface Tab
{
    /**
     * Create the new tab
     *
     * @param string $key   The key to associate with this tab.
     * @param string $title The title which should be used when displaying the
     *                      link.
     * @param string $route The route to the specified resource, pre-generated.
     *
     * @return void
     */
    public function __construct($key, $title, $route);

    /**
     * Get the key for the tab.
     *
     * @return string
     */
    public function getKey();

    /**
     * Get the title for the tab.
     *
     * @return string
     */
    public function getTitle();

    /**
     * Get the route/URL for the tab.
     *
     * @return string
     */
    public function getRoute();
}
