<?php
/**
 * SeoPageMetaBulkUpload Request
 *
 * PHP Version 7
 *
 * @category Mtc\Core\Http\Requests\Admin
 * @package  Mtc\Core\Admin
 * @author   Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */

namespace Mtc\Core\Http\Requests\Admin;

use Illuminate\Foundation\Http\FormRequest;

/**
 * Validate an incoming file upload for updating page metadata with bulk file
 *
 * @category Mtc\Core\Http\Requests\Admin
 * @package  Mtc\Core\Admin
 * @author   Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
class SeoPageMetaBulkUpload extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'meta_csv' => 'required|mimes:csv,txt',
        ];
    }
}
