<?php

namespace Mtc\Core\Http\ViewComposers;

use Mtc\Core\Auth\Permission;
use Mtc\Core\Auth\Role;
use Illuminate\View\View;

class RolesPermissionsComposer
{
    public function compose(View $view)
    {
        $view->with(
            [
            'roles' => Role::orderBy('name')->get(),
            'permission_groups' => Permission::orderBy('permission_group')
                ->orderBy('name')
                ->get()
                ->map(function($permission) {
                    $permission->display_name = ucwords(str_replace('-', ' ', $permission->name));
                    return $permission;
                })->groupBy('permission_group'),
            ]
        );
    }
}
